/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetServer;
import carpet.fakes.IngredientInterface;
import carpet.fakes.RecipeManagerInterface;
import carpet.utils.Messenger;
import carpet.utils.WoolTool;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2185;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3956;
import net.minecraft.class_4275;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;

public class HopperCounter {
    public static final Map<class_1767, HopperCounter> COUNTERS;
    public static final class_5251 WHITE;
    public final class_1767 color;
    private final String prettyColour;
    private final Object2LongMap<class_1792> counter = new Object2LongLinkedOpenHashMap();
    private long startTick = -1L;
    private long startMillis;
    private static final Map<class_1792, class_2248> DEFAULTS;

    private HopperCounter(class_1767 color) {
        this.color = color;
        this.prettyColour = WoolTool.Material2DyeName.getOrDefault(color.method_7794(), "w ") + color.method_7792();
    }

    public void add(MinecraftServer server, class_1799 stack) {
        if (this.startTick < 0L) {
            this.startTick = server.method_3847(class_1937.field_25179).method_8510();
            this.startMillis = System.currentTimeMillis();
        }
        class_1792 item = stack.method_7909();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.method_7947());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.method_3847(class_1937.field_25179).method_8510();
        this.startMillis = System.currentTimeMillis();
    }

    public static void resetAll(MinecraftServer server, boolean fresh) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
            if (!fresh) continue;
            counter.startTick = -1L;
        }
    }

    public static List<class_2561> formatAll(MinecraftServer server, boolean realtime) {
        ArrayList<class_2561> text = new ArrayList<class_2561>();
        for (HopperCounter counter : COUNTERS.values()) {
            List<class_2561> temp = counter.format(server, realtime, false);
            if (temp.size() <= 1) continue;
            if (!text.isEmpty()) {
                text.add(Messenger.s(""));
            }
            text.addAll(temp);
        }
        if (text.isEmpty()) {
            text.add(Messenger.s("No items have been counted yet."));
        }
        return text;
    }

    public List<class_2561> format(MinecraftServer server, boolean realTime, boolean brief) {
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.method_3847(class_1937.field_25179).method_8510() - this.startTick, 1L);
        if (this.startTick < 0L || ticks == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c("b" + this.prettyColour, "w : ", "gi -, -/h, - min "));
            }
            return Collections.singletonList(Messenger.c(this.prettyColour, "w  hasn't started counting yet"));
        }
        long total = this.getTotalItems();
        if (total == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c("b" + this.prettyColour, "w : ", "wb 0", "w , ", "wb 0", "w /h, ", String.format("wb %.1f ", (double)ticks / 1200.0), "w min"));
            }
            return Collections.singletonList(Messenger.c("w No items for ", this.prettyColour, String.format("w  yet (%.2f min.%s)", (double)ticks / 1200.0, realTime ? " - real time" : ""), "nb  [X]", "^g reset", "!/counter " + this.color.method_7792() + " reset"));
        }
        if (brief) {
            return Collections.singletonList(Messenger.c("b" + this.prettyColour, "w : ", "wb " + total, "w , ", "wb " + total * 72000L / ticks, "w /h, ", String.format("wb %.1f ", (double)ticks / 1200.0), "w min"));
        }
        ArrayList<class_2561> items = new ArrayList<class_2561>();
        items.add(Messenger.c("w Items for ", this.prettyColour, "w  (", String.format("wb %.2f", (double)ticks * 1.0 / 1200.0), "w  min" + (realTime ? " - real time" : "") + "), ", "w total: ", "wb " + total, "w , (", String.format("wb %.1f", (double)total * 1.0 * 72000.0 / (double)ticks), "w /h):", "nb [X]", "^g reset", "!/counter " + this.color + " reset"));
        items.addAll(this.counter.object2LongEntrySet().stream().sorted((e, f) -> Long.compare(f.getLongValue(), e.getLongValue())).map(e -> {
            class_1792 item = (class_1792)e.getKey();
            class_5250 itemName = class_2561.method_43471((String)item.method_7876());
            class_2583 itemStyle = itemName.method_10866();
            class_5251 color = HopperCounter.guessColor(item);
            itemName.method_10862(color != null ? itemStyle.method_27703(color) : itemStyle.method_10978(Boolean.valueOf(true)));
            long count = e.getLongValue();
            return Messenger.c("g - ", itemName, "g : ", "wb " + count, "g , ", String.format("wb %.1f", (double)count * 72000.0 / (double)ticks), "w /h");
        }).collect(Collectors.toList()));
        return items;
    }

    public static int appropriateColor(int color) {
        if (color == 0) {
            return class_3620.field_16022.field_16011;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (r < 70) {
            r = 70;
        }
        if (g < 70) {
            g = 70;
        }
        if (b < 70) {
            b = 70;
        }
        return (r << 16) + (g << 8) + b;
    }

    public static class_5251 fromItem(class_1792 item) {
        if (DEFAULTS.containsKey(item)) {
            return class_5251.method_27717((int)HopperCounter.appropriateColor(HopperCounter.DEFAULTS.get((Object)item).method_26403().field_16011));
        }
        if (item instanceof class_1769) {
            return class_5251.method_27717((int)HopperCounter.appropriateColor(((class_1769)item).method_7802().method_7794().field_16011));
        }
        class_2248 block = null;
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        if (item instanceof class_1747) {
            block = ((class_1747)item).method_7711();
        } else if (class_2378.field_11146.method_17966(id).isPresent()) {
            block = (class_2248)class_2378.field_11146.method_10223(id);
        }
        if (block != null) {
            if (block instanceof class_2185) {
                return class_5251.method_27717((int)HopperCounter.appropriateColor(((class_2185)block).method_9303().method_7794().field_16011));
            }
            if (block instanceof class_4275) {
                return class_5251.method_27717((int)HopperCounter.appropriateColor(((class_4275)block).method_10622().method_7794().field_16011));
            }
            return class_5251.method_27717((int)HopperCounter.appropriateColor(block.method_26403().field_16011));
        }
        return null;
    }

    public static class_5251 guessColor(class_1792 item) {
        class_5251 direct = HopperCounter.fromItem(item);
        if (direct != null) {
            return direct;
        }
        if (CarpetServer.minecraft_server == null) {
            return WHITE;
        }
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        for (class_3956 type : class_2378.field_17597) {
            for (class_1860<?> r : ((RecipeManagerInterface)CarpetServer.minecraft_server.method_3772()).getAllMatching(type, id)) {
                for (class_1856 ingredient : r.method_8117()) {
                    for (Collection<class_1799> stacks : ((IngredientInterface)ingredient).getRecipeStacks()) {
                        for (class_1799 iStak : stacks) {
                            class_5251 cand = HopperCounter.fromItem(iStak.method_7909());
                            if (cand == null) continue;
                            return cand;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static HopperCounter getCounter(String color) {
        try {
            class_1767 colorEnum = class_1767.valueOf((String)color.toUpperCase(Locale.ROOT));
            return COUNTERS.get(colorEnum);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public long getTotalItems() {
        return this.counter.isEmpty() ? 0L : this.counter.values().longStream().sum();
    }

    static {
        WHITE = class_5251.method_27718((class_124)class_124.field_1068);
        EnumMap<class_1767, HopperCounter> counterMap = new EnumMap<class_1767, HopperCounter>(class_1767.class);
        for (class_1767 color : class_1767.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Collections.unmodifiableMap(counterMap);
        DEFAULTS = Map.ofEntries(Map.entry(class_1802.field_8491, class_2246.field_10490), Map.entry(class_1802.field_8880, class_2246.field_10314), Map.entry(class_1802.field_17499, class_2246.field_10294), Map.entry(class_1802.field_17500, class_2246.field_10215), Map.entry(class_1802.field_17501, class_2246.field_10491), Map.entry(class_1802.field_17502, class_2246.field_10314), Map.entry(class_1802.field_17509, class_2246.field_10095), Map.entry(class_1802.field_17510, class_2246.field_10491), Map.entry(class_1802.field_17511, class_2246.field_10459), Map.entry(class_1802.field_17512, class_2246.field_10491), Map.entry(class_1802.field_17513, class_2246.field_10514), Map.entry(class_1802.field_17515, class_2246.field_10146), Map.entry(class_1802.field_17514, class_2246.field_10446), Map.entry(class_1802.field_17516, class_2246.field_10580), Map.entry(class_1802.field_17517, class_2246.field_10240), Map.entry(class_1802.field_8600, class_2246.field_10161), Map.entry(class_1802.field_8695, class_2246.field_10205), Map.entry(class_1802.field_8620, class_2246.field_10085), Map.entry(class_1802.field_8477, class_2246.field_10201), Map.entry(class_1802.field_22020, class_2246.field_22108), Map.entry(class_1802.field_17525, class_2246.field_10490), Map.entry(class_1802.field_17526, class_2246.field_10215), Map.entry(class_1802.field_17527, class_2246.field_10314), Map.entry(class_1802.field_17529, class_2246.field_10459), Map.entry(class_1802.field_8179, class_2246.field_10095), Map.entry(class_1802.field_8279, class_2246.field_10314), Map.entry(class_1802.field_8861, class_2246.field_10359), Map.entry(class_1802.field_8389, class_2246.field_10459), Map.entry(class_1802.field_8504, class_2246.field_10459), Map.entry(class_1802.field_8726, class_2246.field_10611), Map.entry(class_1802.field_8046, class_2246.field_10515), Map.entry(class_1802.field_8367, class_2246.field_10205), Map.entry(class_1802.field_8429, class_2246.field_10611), Map.entry(class_1802.field_8209, class_2246.field_10218), Map.entry(class_1802.field_8511, class_2246.field_10113), Map.entry(class_1802.field_8323, class_2246.field_10143), Map.entry(class_1802.field_8846, class_2246.field_10095), Map.entry(class_1802.field_8567, class_2246.field_10611), Map.entry(class_1802.field_8748, class_2246.field_10314), Map.entry(class_1802.field_8186, class_2246.field_10515), Map.entry(class_1802.field_8497, class_2246.field_10545), Map.entry(class_1802.field_8635, class_2246.field_10030), Map.entry(class_1802.field_8680, class_2246.field_10515), Map.entry(class_1802.field_8054, class_2246.field_10423), Map.entry(class_1802.field_8161, class_2246.field_10028), Map.entry(class_1802.field_8153, class_2246.field_10446), Map.entry(class_1802.field_8145, class_2246.field_10146), Map.entry(class_1802.field_8745, class_2246.field_9975), Map.entry(class_1802.field_8601, class_2246.field_10171), Map.entry(class_1802.field_8407, class_2246.field_10446), Map.entry(class_1802.field_8621, class_2246.field_10104), Map.entry(class_1802.field_8794, class_2246.field_10146), Map.entry(class_1802.field_8543, class_2246.field_10491), Map.entry(class_1802.field_8705, class_2246.field_10382), Map.entry(class_1802.field_8187, class_2246.field_10164), Map.entry(class_1802.field_8103, class_2246.field_10446), Map.entry(class_1802.field_8696, class_2246.field_10460), Map.entry(class_1802.field_8116, class_2246.field_10302), Map.entry(class_1802.field_8606, class_2246.field_10166), Map.entry(class_1802.field_8666, class_2246.field_10123), Map.entry(class_1802.field_8108, class_2246.field_10143), Map.entry(class_1802.field_8714, class_2246.field_10444), Map.entry(class_1802.field_8478, class_2246.field_10184), Map.entry(class_1802.field_8479, class_2246.field_10446), Map.entry(class_1802.field_8183, class_2246.field_10205), Map.entry(class_1802.field_8634, class_2246.field_22127), Map.entry(class_1802.field_8137, class_2246.field_10201), Map.entry(class_1802.field_8434, class_2246.field_10174), Map.entry(class_1802.field_8662, class_2246.field_10135), Map.entry(class_1802.field_8245, class_2246.field_10161), Map.entry(class_1802.field_8233, class_2246.field_10286), Map.entry(class_1802.field_8815, class_2246.field_10603), Map.entry(class_1802.field_8864, class_2246.field_10166), Map.entry(class_1802.field_8207, class_2246.field_10502), Map.entry(class_1802.field_20414, class_2246.field_21212), Map.entry(class_1802.field_8448, class_2246.field_10166), Map.entry(class_1802.field_8288, class_2246.field_10143), Map.entry(class_1802.field_8547, class_2246.field_10135), Map.entry(class_1802.field_8070, class_2246.field_10446), Map.entry(class_1802.field_8614, class_2246.field_10166), Map.entry(class_1802.field_8803, class_2246.field_10166), Map.entry(class_1802.field_27022, class_2246.field_27119), Map.entry(class_1802.field_27063, class_2246.field_27159));
    }
}

